/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.ui;

import frc.emul.api.persistence.IPersistenceReader;
import frc.emul.api.persistence.IPersistenceWriter;
import frc.emul.api.persistence.IPersistentObject;
import frc.emul.api.persistence.IPersistentSection;
import frc.emul.api.persistence.PersistenceException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GfxItem
implements Comparable<GfxItem>,
IPersistentObject {
    public float x0;
    public float y0;
    public float x1;
    public float y1;
    public int brightness;
    private boolean pt;
    private static List<GfxItem> pool = new ArrayList<GfxItem>();

    private GfxItem() {
    }

    public String toString() {
        return this.isPoint() ? "[" + this.x0 + "," + this.y0 + " @" + this.brightness + "]" : "[" + this.x0 + "," + this.y0 + " to " + this.x1 + "," + this.y1 + " @" + this.brightness + "]";
    }

    public boolean isPoint() {
        return this.pt;
    }

    public final GfxItem clone() {
        GfxItem gfxItem = new GfxItem();
        if (this.pt) {
            gfxItem.pt = true;
        } else {
            gfxItem.x1 = this.x1;
            gfxItem.y1 = this.y1;
        }
        gfxItem.x0 = this.x0;
        gfxItem.y0 = this.y0;
        gfxItem.brightness = this.brightness;
        return gfxItem;
    }

    @Override
    public int compareTo(GfxItem gfxItem) {
        return this.brightness - gfxItem.brightness;
    }

    @Override
    public IPersistentSection getSection() {
        return null;
    }

    @Override
    public void store(IPersistenceWriter iPersistenceWriter) throws PersistenceException {
        iPersistenceWriter.write(this.brightness);
        iPersistenceWriter.write(this.x0);
        iPersistenceWriter.write(this.y0);
        iPersistenceWriter.write(this.pt);
        if (!this.pt) {
            iPersistenceWriter.write(this.x1);
            iPersistenceWriter.write(this.y1);
        }
    }

    @Override
    public void load(IPersistenceReader iPersistenceReader) throws PersistenceException {
        this.brightness = iPersistenceReader.readInt();
        this.x0 = iPersistenceReader.readFloat();
        this.y0 = iPersistenceReader.readFloat();
        this.pt = iPersistenceReader.readBool();
        if (!this.pt) {
            this.x1 = iPersistenceReader.readFloat();
            this.y1 = iPersistenceReader.readFloat();
        }
    }

    public static final GfxItem newLine(float f, float f2, float f3, float f4, int n) {
        GfxItem gfxItem = GfxItem.allocItem();
        gfxItem.x0 = f;
        gfxItem.y0 = f2;
        gfxItem.x1 = f3;
        gfxItem.y1 = f4;
        gfxItem.pt = false;
        gfxItem.brightness = n;
        return gfxItem;
    }

    public static final GfxItem newPoint(float f, float f2, int n) {
        GfxItem gfxItem = GfxItem.allocItem();
        gfxItem.x0 = f;
        gfxItem.y0 = f2;
        gfxItem.pt = true;
        gfxItem.brightness = n;
        return gfxItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freeItem(GfxItem gfxItem) {
        List<GfxItem> list = pool;
        synchronized (list) {
            pool.add(gfxItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final GfxItem allocItem() {
        List<GfxItem> list = pool;
        synchronized (list) {
            if (pool.isEmpty()) {
                return new GfxItem();
            }
            return pool.remove(pool.size() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freeItems(List<GfxItem> list) {
        List<GfxItem> list2 = pool;
        synchronized (list2) {
            pool.addAll(list);
        }
        list.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearPool() {
        List<GfxItem> list = pool;
        synchronized (list) {
            pool = new ArrayList<GfxItem>();
        }
    }

    public static final void sortByBrightness(List<GfxItem> list) {
        Collections.sort(list);
    }
}

